-- select --distinct pipeline_id,pipeline_name
--        contract_id,manager_login, manager_name
-- from snb_b2b.niksm_b2b_contracts_info
-- where 1=1
-- -- and which_crm=6
-- and contract_id in('2786370/21')
-- --and pipeline_id in (6,16)
with base_t as (
    select cw.key as cw_ticket_key
         , cw.type
         , cw.status
         , cw.resolution
         , cw.resolution = 'fixed' and cw.type='task'                                                        as fixed_flg
         , (to_timestamp(EXTRACT(EPOCH FROM cw.created::timestamp)) at time zone
            'Europe/Moscow')::timestamp                                                                      as cw_date_tiket_open
         , (to_timestamp(EXTRACT(EPOCH FROM cw.created::timestamp)) at time zone
            'Europe/Moscow')::date                                                                           as created_CW
         , (to_timestamp(ld.tm_created_dttm) at time zone 'Europe/Moscow')::date                             as created_TM
         , cw.deal
         , coalesce(cw.deal, ld.tm_ticket_key) as group_flg
         , coalesce(min(case
                   when (to_timestamp(ld.tm_created_dttm) at time zone 'Europe/Moscow')::date
                       <= coalesce((to_timestamp(EXTRACT(EPOCH FROM cw.created::timestamp)) at time zone 'Europe/Moscow')::date,current_date)
                       then tm_ticket_key end) over (partition by coalesce(cw.deal, ld.tm_ticket_key) ) =
           tm_ticket_key,false)                                                                                    as TM_flg
         , ld.tm_ticket_key
         , ld.appeal_flg::int
         , SUBSTRING(cw.deal,'Y*([0-9]{1,100})')       ::integer     as deal_id
         , lead_confirmed_flg::int
         , (to_timestamp(ld.tm_lead_confirmed_dttm) at time zone 'Europe/Moscow')                            as tm_lead_confirmed_dttm
         , (to_timestamp(ld.tm_open_dttm) at time zone 'Europe/Moscow')                                      as tm_date_tiket_open
         , tm_open_flg::int
         , (to_timestamp(ld.tm_work_dttm) at time zone 'Europe/Moscow')                                      as tm_date_tiket_work
         , tm_work_flg::int
from (select * from snb_b2b.voytekh_corpwelcome
              where (to_timestamp(EXTRACT(EPOCH FROM created::timestamp)) at time zone'Europe/Moscow')::date
                        >='2022-01-01')  cw
full join snb_b2b.alextitov_logdata994_ticket_crt ld on ld.cw_ticket_key = cw.key
                                                            and  (to_timestamp(ld.tm_created_dttm) at time zone 'Europe/Moscow')::date  >='2022-01-01'
where 1 = 1
--and type in ('task')
--and cw.deal in ('https://yandexdelivery.pipedrive.com/deal/122283','https://yandexdelivery.pipedrive.com/deal/116608')
-- and cw.key is null
--and tm_ticket_key='TICKETCREATORTE-10164'
--group by cw.deal
--having sum(case when tm_ticket_key is not null then 1 else 0 end)>1
)
--   select * from base_t;
, t as (
    select cw_ticket_key
         , type
         , status
         , resolution
         , fixed_flg
         , cw_date_tiket_open
         , created_CW
         , deal
         , deal_id
         , group_flg

         , max(case when TM_flg = true then created_TM end) over (partition by group_flg) as  created_TM
         , max(case when TM_flg = true then tm_ticket_key end) over (partition by group_flg) as         tm_ticket_key
         , min(case when TM_flg = true then appeal_flg end) over (partition by group_flg) as  appeal_flg
         , max(case when TM_flg = true then lead_confirmed_flg end)
           over (partition by group_flg) as                                                             lead_confirmed_flg
         , max(case when TM_flg = true then tm_lead_confirmed_dttm end)
           over (partition by group_flg) as                                                             tm_lead_confirmed_dttm
         , max(case when TM_flg = true then tm_date_tiket_open end)
           over (partition by group_flg) as                                                             tm_date_tiket_open
         , max(case when TM_flg = true then tm_open_flg end) over (partition by group_flg) as tm_open_flg
         , max(case when TM_flg = true then tm_date_tiket_work end)
           over (partition by group_flg) as                                                             tm_date_tiket_work
         , max(case when TM_flg = true then tm_work_flg end) over (partition by group_flg) as tm_work_flg
    from base_t
)
, tbl as (
    select t.*

           ,t.fixed_flg = false and dh.status = 'lost' as reinstated_cw_flg,
           dlf.status = 'lost'                        as status_lost,
           dlf.lost_reason,
           dlf.contract_id,
           dlf.contract_type = 'ОФЕРТА'               as contract_offerta_flg,
           dlf.manager_group,
           dlf.manager_login,
           dlf.manager_name,
           dlf.channel,
           dlf.tags,
           dlf.potential,
           dlf.corp_client_id,
           to_timestamp(EXTRACT(EPOCH FROM dlf.add_time))at time zone 'Europe/Moscow' as open_deal_date,
           dlf.add_date,
           dlf.pipeline_id = 18                       as phinics_flg
           , min(case when vact.type = 'call' and  to_timestamp(EXTRACT(EPOCH FROM vact.marked_as_done_time))at time zone 'Europe/Moscow'>= t.cw_date_tiket_open
                    then  to_timestamp(EXTRACT(EPOCH FROM vact.marked_as_done_time))at time zone 'Europe/Moscow'
                    else null end) as manager_call_date

    from t
             left join snb_b2b.niksm_b2b_deals_info_hist dh
                       on dh.deal_id = t.deal_id and dh.snapshot_date = t.created_CW and dh.which_crm = 6
             left join snb_b2b.niksm_b2b_deals_info dlf on dlf.deal_id = t.deal_id and dlf.which_crm = 6
              left join snb_b2b.voytekh_pd2_activity vact  on vact.deal_id=t.deal_id and vact.which_crm = 6
  group by

   t.cw_ticket_key
           , t.type
         , t.status
         , t.resolution
         , t.fixed_flg
         , t.cw_date_tiket_open
         , t.created_CW
         , t.deal
         , t.deal_id
         , t.group_flg

         , t.created_TM
         , t.tm_ticket_key
         , t.appeal_flg
         , t.lead_confirmed_flg
         , t.tm_lead_confirmed_dttm
         , t.tm_date_tiket_open
         , t.tm_open_flg
         , t.tm_date_tiket_work
         , t.tm_work_flg
          ,t.fixed_flg = false and dh.status = 'lost'

           ,dlf.status = 'lost'                        ,
           dlf.lost_reason,
           dlf.contract_id,
           dlf.contract_type = 'ОФЕРТА'              ,
           dlf.manager_group,
           dlf.manager_login,
           dlf.manager_name,
           dlf.channel,
           dlf.tags,
           dlf.potential,
           dlf.corp_client_id,
           to_timestamp(EXTRACT(EPOCH FROM dlf.add_time))at time zone 'Europe/Moscow',
           dlf.add_date,
           dlf.pipeline_id = 18
)
, tbl2 as (
    select tbl.cw_ticket_key
         , tbl.type
         , tbl.status
         , tbl.resolution
         , tbl.fixed_flg
         , tbl.cw_date_tiket_open
         , tbl.created_CW
         , tbl.deal
         , tbl.deal_id
         , tbl.group_flg

         , tbl.created_TM
         , tbl.tm_ticket_key
         , tbl.appeal_flg
         , tbl.lead_confirmed_flg
         , tbl.tm_lead_confirmed_dttm
         , tbl.tm_date_tiket_open
         , tbl.tm_open_flg
         , tbl.tm_date_tiket_work
         , tbl.tm_work_flg
         , tbl.reinstated_cw_flg
         , tbl.status_lost
         , tbl.lost_reason
         , tbl.contract_id
         , tbl.contract_offerta_flg
         , tbl.manager_group
         , tbl.manager_login
         , tbl.manager_name
         , tbl.channel
         , tbl.tags
         , tbl.potential
         , tbl.corp_client_id
         , tbl.open_deal_date
         , tbl.add_date
         , tbl.phinics_flg
         , tbl.manager_call_date
         , sum(case
                   when fct_cntr.utc_order_created_dttm between tbl.add_date and tbl.add_date + 30
                       then fct_cntr.delivery_point_cnt end) as cnt_del_30
         , sum(fct_cntr.delivery_point_cnt) > 0              as del_flag

    from tbl
             left join taxi_cdm_marketplace.fct_order as fct_cntr on tbl.contract_id = fct_cntr.corp_contract_id and
                                                                     fct_cntr.utc_order_created_dttm >= '2022-01-01'
--     where --reinstated_cw_flg=true  deal='https://yandexdelivery.pipedrive.com/deal/113087'
    group by tbl.cw_ticket_key
           , tbl.type
           , tbl.status
           , tbl.resolution
           , tbl.fixed_flg
           , tbl.cw_date_tiket_open
           , tbl.created_CW
           , tbl.deal
           , tbl.deal_id
           , tbl.group_flg
           , tbl.created_TM
           , tbl.tm_ticket_key
           , tbl.appeal_flg
           , tbl.lead_confirmed_flg
           , tbl.tm_lead_confirmed_dttm
           , tbl.tm_date_tiket_open
           , tbl.tm_open_flg
           , tbl.tm_date_tiket_work
           , tbl.tm_work_flg
           , tbl.reinstated_cw_flg
           , tbl.status_lost, tbl.lost_reason, tbl.contract_id, tbl.contract_offerta_flg, tbl.manager_group
           , tbl.manager_login, tbl.manager_name, tbl.channel, tbl.tags, tbl.potential, tbl.corp_client_id
           , tbl.open_deal_date, tbl.add_date, tbl.phinics_flg, tbl.manager_call_date
)
, fin as (
    select tbl.cw_ticket_key
         , tbl.type
         , tbl.status
         , tbl.resolution
         , tbl.fixed_flg
         , tbl.cw_date_tiket_open
         , tbl.created_CW
         , tbl.deal
         , tbl.deal_id
         , tbl.group_flg
         , tbl.created_TM
         , tbl.tm_ticket_key
         , tbl.appeal_flg
         , tbl.lead_confirmed_flg
         , tbl.tm_lead_confirmed_dttm
         , tbl.tm_date_tiket_open
         , tbl.tm_open_flg
         , tbl.tm_date_tiket_work
         , tbl.tm_work_flg
         , tbl.reinstated_cw_flg
         , tbl.status_lost
         , tbl.lost_reason
         , tbl.contract_id
         , tbl.contract_offerta_flg
         , tbl.manager_group
         , tbl.manager_login
         , tbl.manager_name
         , tbl.channel
         , tbl.tags
         , tbl.potential
         , tbl.corp_client_id
         , tbl.open_deal_date
         , tbl.add_date
         , tbl.phinics_flg
         , tbl.manager_call_date
        ,coalesce(tbl.cnt_del_30, sum(case when utc_order_created_dttm between tbl.add_date and tbl.add_date + 30
            then delivery_point_cnt end)) as cnt_del_30
    , coalesce(tbl.del_flag, sum(delivery_point_cnt) > 0) as del_flag
    from tbl2 tbl
             left join taxi_cdm_marketplace.fct_order as fct_cntr
                       on tbl.contract_id is null and tbl.phinics_flg = true and
                          tbl.corp_client_id = fct_cntr.corp_client_id and
                          fct_cntr.utc_order_created_dttm >= '2022-01-01'
    group by tbl.cw_ticket_key
           , tbl.type
           , tbl.status
           , tbl.resolution
           , tbl.fixed_flg
           , tbl.cw_date_tiket_open
           , tbl.created_CW
           , tbl.deal
           , tbl.deal_id
           , tbl.group_flg
           , tbl.created_TM
           , tbl.tm_ticket_key
           , tbl.appeal_flg
           , tbl.lead_confirmed_flg
           , tbl.tm_lead_confirmed_dttm
           , tbl.tm_date_tiket_open
           , tbl.tm_open_flg
           , tbl.tm_date_tiket_work
           , tbl.tm_work_flg
           , tbl.reinstated_cw_flg
           , tbl.status_lost, tbl.lost_reason, tbl.contract_id, tbl.contract_offerta_flg, tbl.manager_group
           , tbl.manager_login, tbl.manager_name, tbl.channel, tbl.tags, tbl.potential, tbl.corp_client_id
           , tbl.open_deal_date, tbl.add_date, tbl.phinics_flg, tbl.manager_call_date
           , tbl.cnt_del_30, tbl.del_flag
)
, ff as (
select tbl.cw_ticket_key
           , tbl.type
           , tbl.status
           , tbl.resolution
           , tbl.fixed_flg
           , tbl.cw_date_tiket_open
           , tbl.created_CW
           , tbl.deal
           , tbl.deal_id
           , tbl.group_flg
           , tbl.created_TM
           , tbl.tm_ticket_key
           , tbl.appeal_flg
           , tbl.lead_confirmed_flg
           , tbl.tm_lead_confirmed_dttm
           , tbl.tm_date_tiket_open
           , tbl.tm_open_flg
           , tbl.tm_date_tiket_work
           , tbl.tm_work_flg
           , tbl.reinstated_cw_flg
           , case when tbl.status_lost=true then 'Проигранно'
                  when del_flag=true then 'Есть доставки'
                  when contract_id is not null then 'Заключен контракт'
                  when deal_id is not null then 'Переговоры' end as status_deal
           , tbl.status_lost, tbl.lost_reason, tbl.contract_id, tbl.contract_offerta_flg, tbl.manager_group
           , tbl.manager_login, tbl.manager_name, tbl.channel, tbl.tags, tbl.potential, tbl.corp_client_id
           , tbl.open_deal_date, tbl.add_date, tbl.phinics_flg, tbl.manager_call_date
           , tbl.cnt_del_30, tbl.del_flag
from fin tbl
)
select * from ff
;
------------------------------------------------------------------------------------

drop table if exists base_t
create temporary table base_t as
with a as (
    select cw.key                                                                                               as cw_ticket_key
         , cw.type
         , cw.status
         , cw.resolution
         , cw.resolution = 'fixed' and cw.type = 'task'                                                         as fixed_flg
         , (to_timestamp(EXTRACT(EPOCH FROM cw.created::timestamp)) at time zone
            'Europe/Moscow')::timestamp                                                                         as cw_date_tiket_open
         , (to_timestamp(EXTRACT(EPOCH FROM cw.created::timestamp)) at time zone
            'Europe/Moscow')::date                                                                              as created_CW
         , (to_timestamp(EXTRACT(EPOCH FROM cw.created::timestamp)) at time zone
            'Europe/Moscow')::date -
           7                                                                                                    as created_CW_7
         , (to_timestamp(ld.tm_created_dttm) at time zone 'Europe/Moscow')::date                                as created_TM
         , cw.deal
         , coalesce(cw.deal, ld.tm_ticket_key)                                                                  as group_flg
         , coalesce(min(case
                            when (to_timestamp(coalesce(ld.tm_work_dttm, ld.tm_created_dttm)) at time zone
                                  'Europe/Moscow')::date
                                     >= coalesce((to_timestamp(EXTRACT(EPOCH FROM cw.created::timestamp)) at time zone
                                                  'Europe/Moscow')::date, current_date)
                                and (to_timestamp(coalesce(ld.tm_work_dttm, ld.tm_created_dttm)) at time zone
                                     'Europe/Moscow')::date - 7
                                     <= coalesce((to_timestamp(EXTRACT(EPOCH FROM cw.created::timestamp)) at time zone
                                                  'Europe/Moscow')::date, current_date)
                                then tm_ticket_key end) over (partition by coalesce(cw.deal, ld.tm_ticket_key) )
--= tm_ticket_key
        ,
                    '1')                                                                                        as TM_flg --false
         , ld.tm_ticket_key
         , ld.appeal_flg::int
         , SUBSTRING(cw.deal, 'Y*([0-9]{1,100})') ::integer                                                     as deal_id
         , lead_confirmed_flg::int
         , (to_timestamp(ld.tm_lead_confirmed_dttm) at time zone 'Europe/Moscow')                               as tm_lead_confirmed_dttm
         , (to_timestamp(ld.tm_open_dttm) at time zone 'Europe/Moscow')                                         as tm_date_tiket_open
         , tm_open_flg::int
         , (to_timestamp(ld.tm_work_dttm) at time zone 'Europe/Moscow')                                         as tm_date_tiket_work
         , tm_work_flg::int
    from (select *
          from snb_b2b.voytekh_corpwelcome
             where (to_timestamp(EXTRACT(EPOCH FROM created::timestamp)) at time zone'Europe/Moscow')::date >='2022-01-01'
         ) cw
             full join snb_b2b.alextitov_logdata994_ticket_crt ld on ld.cw_ticket_key = cw.key
         and  (to_timestamp(ld.tm_created_dttm) at time zone 'Europe/Moscow')::date  >='2022-01-01'
    where 1 = 1
--and type in ('task')
      and cw.deal in ('https://yandexdelivery.pipedrive.com/deal/122283' ,
        'https://yandexdelivery.pipedrive.com/deal/116608' ,
        'https://yandexdelivery.pipedrive.com/deal/70401')
 --   order by deal
)
, aa as (
    select a.group_flg


         , a.cw_ticket_key
         , a.type
         , a.status
         , a.resolution
         , a.fixed_flg
         , a.cw_date_tiket_open
         , a.created_cw
         , a.created_cw_7
         , a.deal
         , a.deal_id

         --,a.tm_flg
         , a.tm_ticket_key
         , a.created_tm
         , a.appeal_flg
         , a.lead_confirmed_flg
         , a.tm_lead_confirmed_dttm
         , a.tm_date_tiket_open
         , a.tm_open_flg
         , a.tm_date_tiket_work
         , a.tm_work_flg

         , min(aa.tm_ticket_key) tm_ticket_key_w
         , max(case when a.tm_ticket_key=min(aa.tm_ticket_key)  then a.created_TM end)
             over(partition by coalesce(min(aa.tm_ticket_key), a.cw_ticket_key, a.tm_ticket_key)) created_TM_w
         , max(case when a.tm_ticket_key=min(aa.tm_ticket_key)  then a.appeal_flg end)
             over(partition by coalesce(min(aa.tm_ticket_key), a.cw_ticket_key, a.tm_ticket_key)) appeal_flg_w
         ,max(case when a.tm_ticket_key=min(aa.tm_ticket_key)  then a.lead_confirmed_flg end)
             over(partition by coalesce(min(aa.tm_ticket_key), a.cw_ticket_key, a.tm_ticket_key)) lead_confirmed_flg_w
         ,max(case when a.tm_ticket_key=min(aa.tm_ticket_key)  then a.tm_lead_confirmed_dttm end)
             over(partition by coalesce(min(aa.tm_ticket_key), a.cw_ticket_key, a.tm_ticket_key)) tm_lead_confirmed_dttm_w
         ,max(case when a.tm_ticket_key=min(aa.tm_ticket_key)  then a.tm_date_tiket_open end)
             over(partition by coalesce(min(aa.tm_ticket_key), a.cw_ticket_key, a.tm_ticket_key)) tm_date_tiket_open_w
         ,max(case when a.tm_ticket_key=min(aa.tm_ticket_key)  then a.tm_open_flg end)
             over(partition by coalesce(min(aa.tm_ticket_key), a.cw_ticket_key, a.tm_ticket_key)) tm_open_flg_w
         ,max(case when a.tm_ticket_key=min(aa.tm_ticket_key)  then a.tm_date_tiket_work end)
             over(partition by coalesce(min(aa.tm_ticket_key), a.cw_ticket_key, a.tm_ticket_key)) tm_date_tiket_work_w
         ,max(case when a.tm_ticket_key=min(aa.tm_ticket_key)  then a.tm_work_flg end)
             over(partition by coalesce(min(aa.tm_ticket_key), a.cw_ticket_key, a.tm_ticket_key)) tm_work_flg_w
         , row_number()
           over (partition by coalesce(min(aa.tm_ticket_key), a.cw_ticket_key, a.tm_ticket_key) order by a.fixed_flg desc,a.cw_date_tiket_open) as rn
         , row_number()
           over (partition by coalesce(min(aa.tm_ticket_key), a.cw_ticket_key, a.tm_ticket_key) order by a.fixed_flg desc,a.cw_date_tiket_open)=1 as TM_flg
    from a
             left join a aa on a.deal = aa.deal and aa.tm_ticket_key is not null
        and aa.created_tm between a.created_cw_7 and a.created_cw
    group by a.cw_ticket_key
           , a.type
           , a.status
           , a.resolution
           , a.fixed_flg
           , a.cw_date_tiket_open
           , a.created_cw
           , a.created_cw_7
           , a.created_tm
           , a.deal
           , a.group_flg
           --,a.tm_flg
           , a.tm_ticket_key
           , a.appeal_flg
           , a.deal_id
           , a.lead_confirmed_flg
           , a.tm_lead_confirmed_dttm
           , a.tm_date_tiket_open
           , a.tm_open_flg
           , a.tm_date_tiket_work
           , a.tm_work_flg
)
--select * from aa;
select
       group_flg
      , tm_flg

      , case when tm_flg=true then tm_ticket_key_w
             when tm_ticket_key=tm_ticket_key_w and rn<>1 then null
             else tm_ticket_key
          end as tm_ticket_key
     , case when tm_flg=true then created_tm_w
             when tm_ticket_key=tm_ticket_key_w and rn<>1 then null
             else created_tm
         end as created_tm
     , case when tm_flg=true then appeal_flg_w
             when tm_ticket_key=tm_ticket_key_w and rn<>1 then null
             else appeal_flg
         end as appeal_flg
     , case when tm_flg=true then lead_confirmed_flg_w
             when tm_ticket_key=tm_ticket_key_w and rn<>1 then null
             else lead_confirmed_flg
         end as lead_confirmed_flg
     , case when tm_flg=true then tm_lead_confirmed_dttm_w
             when tm_ticket_key=tm_ticket_key_w and rn<>1 then null
             else tm_lead_confirmed_dttm
         end as tm_lead_confirmed_dttm
     , case when tm_flg=true then tm_date_tiket_open_w
             when tm_ticket_key=tm_ticket_key_w and rn<>1 then null
             else tm_date_tiket_open
         end as tm_date_tiket_open
     , case when tm_flg=true then tm_open_flg_w
             when tm_ticket_key=tm_ticket_key_w and rn<>1 then null
             else tm_open_flg
         end as tm_open_flg
     , case when tm_flg=true then tm_date_tiket_work_w
             when tm_ticket_key=tm_ticket_key_w and rn<>1 then null
             else tm_date_tiket_work
         end as tm_date_tiket_work
     , case when tm_flg=true then tm_work_flg_w
             when tm_ticket_key=tm_ticket_key_w and rn<>1 then null
             else tm_work_flg
         end as tm_work_flg

, cw_ticket_key
 , type
 , status
 , resolution
 , fixed_flg
 ,cw_date_tiket_open
 , created_cw
 , created_cw_7
 , deal
 , deal_id
       from aa;
analyse  base_t;



    select t.*

           ,t.fixed_flg = false and dh.status = 'lost' as reinstated_cw_flg

           ,dlf.status = 'lost'                        as status_lost,
           dlf.lost_reason,
           dlf.contract_id,
           dlf.contract_type = 'ОФЕРТА'               as contract_offerta_flg,
           dlf.manager_group,
           dlf.manager_login,
           dlf.manager_name,
           dlf.channel,
           dlf.tags,
           dlf.potential,
           dlf.corp_client_id,
           to_timestamp(EXTRACT(EPOCH FROM dlf.add_time))at time zone 'Europe/Moscow' as open_deal_date,
           dlf.add_date,
           dlf.pipeline_id = 18                       as phinics_flg
           , min(case when vact.type = 'call' and  to_timestamp(EXTRACT(EPOCH FROM vact.marked_as_done_time))at time zone 'Europe/Moscow'>= t.cw_date_tiket_open
                    then  to_timestamp(EXTRACT(EPOCH FROM vact.marked_as_done_time))at time zone 'Europe/Moscow'
                    else null end) as manager_call_date

    from base_t t
             left join snb_b2b.niksm_b2b_deals_info_hist dh
                       on dh.deal_id = t.deal_id and dh.snapshot_date = t.created_CW and dh.which_crm = 6
             left join snb_b2b.niksm_b2b_deals_info dlf on dlf.deal_id = t.deal_id and dlf.which_crm = 6
              left join snb_b2b.voytekh_pd2_activity vact  on vact.deal_id=t.deal_id and vact.which_crm = 6
  group by
    group_flg
    ,t. tm_flg
    ,t. tm_ticket_key
    ,t. created_tm
    ,t. appeal_flg
    ,t. lead_confirmed_flg
    ,t. tm_lead_confirmed_dttm
    , t.tm_date_tiket_open
    ,t. tm_open_flg
    ,t. tm_date_tiket_work
    ,t. tm_work_flg
    ,t. cw_ticket_key
    ,t. type
    ,t. status
    ,t. resolution
    ,t. fixed_flg
    ,t.cw_date_tiket_open
    ,t. created_cw
    , t.created_cw_7
    , t.deal
    , t.deal_id

          ,t.fixed_flg = false and dh.status = 'lost'
           ,dlf.status = 'lost'                        ,
           dlf.lost_reason,
           dlf.contract_id,
           dlf.contract_type = 'ОФЕРТА'              ,
           dlf.manager_group,
           dlf.manager_login,
           dlf.manager_name,
           dlf.channel,
           dlf.tags,
           dlf.potential,
           dlf.corp_client_id,
           to_timestamp(EXTRACT(EPOCH FROM dlf.add_time))at time zone 'Europe/Moscow',
           dlf.add_date,
           dlf.pipeline_id = 18
-- and cw.key is null
--and tm_ticket_key='TICKETCREATORTE-10164'
--group by cw.deal
--having sum(case when tm_ticket_key is not null then 1 else 0 end)>1
